/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.humanoid;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetsByBodyType;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Race;
import technology.rocketjump.undermount.jobs.model.Profession;

public class HumanoidEntityAssetsByRace {
    private Map<Race, HumanoidEntityAssetsByBodyType> raceMap = new EnumMap<Race, HumanoidEntityAssetsByBodyType>(Race.class);

    public HumanoidEntityAssetsByRace() {
        for (Race race : Race.values()) {
            this.raceMap.put(race, new HumanoidEntityAssetsByBodyType());
        }
    }

    public void add(HumanoidEntityAsset asset) {
        Race race = asset.getRace();
        if (race == null) {
            for (HumanoidEntityAssetsByBodyType assetsByBodyType : this.raceMap.values()) {
                assetsByBodyType.add(asset);
            }
        } else {
            this.raceMap.get((Object)race).add(asset);
            this.raceMap.get((Object)Race.ANY).add(asset);
        }
    }

    public HumanoidEntityAsset get(HumanoidEntityAttributes attributes, Profession primaryProfession) {
        Race race = attributes.getRace();
        if (race == null) {
            race = Race.ANY;
        }
        return this.raceMap.get((Object)race).get(attributes, primaryProfession);
    }

    public List<HumanoidEntityAsset> getAll(HumanoidEntityAttributes attributes, Profession primaryProfession) {
        Race race = attributes.getRace();
        if (race == null) {
            race = Race.ANY;
        }
        return this.raceMap.get((Object)race).getAll(attributes, primaryProfession);
    }
}

